###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###
### CRC: DEMAND FOR MOBILE SERVICES             ###*###*###*###*###*###*###*###*###
### DISCRETE CHOICE MODEL                       ###*###*###*###*###*###*###*###*###
### AUXILIARY FUNCTIONS                         ###*###*###*###*###*###*###*###*###
###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###

## Fixed point function for delta
fixedn <- function(delta, mui) {
  num   <- exp(delta + mui) ## --> (J*T)xNS
  den   <- t(sapply(unique(t), function(m) colSums(num[which(t == m), ])))[mkti, ] 
  si    <- num / (1 + den)  ## --> (J*T)xNS
  s     <- rowMeans(si)     ## --> (J*T)x1
  delta <- as.numeric(delta + log(Sa) - log(s)) ## --> (J*T)x1
  return(delta)
}

## Fixed point function for zeta
fixed <- function(zeta) {
  mui   <- S %*% t(zeta[1]*v[1, ]) + q %*% t(zeta[2]*v[2, ])
  delta <- try(squarem(delta0, fixedn, mui = mui, control = list(tol = 1e-10)), silent = T)
  expl  <- class(delta)
  if(expl == 'try-error') {
    si <- delta <- NULL
  } else {
    delta <- delta$par
    num   <- exp(delta + mui) ## --> (J*T)xNS
    den   <- t(sapply(unique(t), function(m) colSums(num[which(t == m), ])))[mkti, ] ## --> (J*T)xNS
    si    <- num / (1 + den)  ## --> (J*T)xNS
  }
  return(list(delta = delta, si = si, expl = expl))
}

## Function to recover primitives
struct <- function(zeta) {
  
  ## Fixed point for delta
  Fout  <- fixed(zeta)
  expl  <- Fout$expl
  
  if(expl == "try-error") {
    
    out <- list(expl = expl)
    
  } else {
    
    ## Delta and shares
    delta <- Fout$delta
    si    <- Fout$si       # individual probabilities
    s     <- rowMeans(si)  # market shares
    
    ## Estimate linear parameters of demand
    b  <- XZPZ %*% delta
    xi <- delta - XPF %*% b
    
    ## Output: parameters & primitives
    out <- list(b = b, delta = delta, xi = xi, expl = expl, si = si)
  }
  
  return(out)
}

## Moment Funcion
gmm <- function(zeta) {
  
  ## Restrictions:
  zeta <- abs(zeta)
  print(zeta)
  
  ## Outputs
  strc <- struct(zeta)
  expl <- strc$expl
  
  if(expl == 'try-error') {
    out <- 1e+10
  } else {
    
    ## Resifuals
    om  <- strc$xi
    out <- t(om) %*% ZPZ %*% om
    out <- as.numeric(out)
  }
  
  print(out)
  return(out)
}


## Error fns: theta_1
omega1 <- function(beta) {
  xi <- delta - XPF %*% beta
  return(xi)
}

## Error fns: theta_2
omega2 <- function(zeta) {
  out  <- struct(zeta)
  xi   <- out$xi
  return(xi)
}

# ____________________________________________________________________________ ####
# END ####