###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###
### CRC: DEMAND FOR MOBILE SERVICES             ###*###*###*###*###*###*###*###*###
### DISCRETE CHOICE MODEL                       ###*###*###*###*###*###*###*###*###
### AUXILIARY FUNCTIONS                         ###*###*###*###*###*###*###*###*###
###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###

## Fixed point function for delta
fixedn <- function(delta, mui) {
  num   <- exp(delta + mui) ## --> (J*T)xNS
  den   <- t(sapply(unique(t), function(m) colSums(num[which(t == m), ])))[mkti, ] 
  si    <- num / (1 + den)  ## --> (J*T)xNS
  s     <- rowMeans(si)     ## --> (J*T)x1
  delta <- as.numeric(delta + log(S) - log(s)) ## --> (J*T)x1
  return(delta)
}

## Fixed point function for zeta
fixed <- function(zeta) {
  mui   <- p %*% t(zeta[6]*v[1, ]) + Sa %*% t(zeta[7]*v[2, ])
  delta <- try(squarem(delta0, fixedn, mui = mui, control = list(tol = 1e-10)), silent = T)
  expl  <- class(delta)
  if(expl == 'try-error') {
    si <- delta <- NULL
  } else {
    delta <- delta$par
    num   <- exp(delta + mui) ## --> (J*T)xNS
    den   <- t(sapply(unique(t), function(m) colSums(num[which(t == m), ])))[mkti, ] ## --> (J*T)xNS
    si    <- num / (1 + den) ## --> (J*T)xNS
  }
  return(list(delta = delta, si = si, expl = expl))
}

## Function to recover primitives
struct <- function(zeta) {
  
  ## Fixed point for delta
  Fout  <- fixed(zeta)
  expl  <- Fout$expl
  
  if(expl == "try-error") {
    
    out <- list(expl = expl)
    
  } else {
    
    ## Delta and shares
    delta <- Fout$delta
    si    <- Fout$si       # individual probabilities
    s     <- rowMeans(si)  # market shares
    
    ## Estimate cm and linear parameters of demand
    alpha   <- zeta[1]
    rho     <- XBr %*% zeta[2:5]
    delta_r <- delta - rho*D - alpha*p
    b       <- XZPZ %*% delta_r
    
    ## Markups & costs:
    aim  <- matrix(alpha, J, NS) + zeta[6]*matrix(v[1, ], J, NS, byrow = T)
    dsdp <- -(aim * si) %*% t(si) / NS            # ds_r/dp_j
    diag(dsdp) <- rowMeans(aim * si * (1 - si))   # ds_j/dp_j (r = j)
    TH   <- H * dsdp
    mkup <- -as.numeric(solve(TH, tol = 1e-40) %*% (s*(1 - D)))
    cm   <- p*(1 - D) - mkup # marginal costs
    
    ## Predicted discount
    rhom  <- matrix(rho, length(rho), NS)
    dsdD  <- -(rhom * si) %*% t(si) / NS
    diag(dsdD) <- rowMeans(rhom * si * (1 - si))
    TD    <- H * dsdD
    mkup2 <- as.numeric(solve(TD, tol = 1e-40) %*% (s*p))
    Dh    <- 1 - (mkup2 + cm)/p
    # summary(cm); sum(cm < 0); sum(cm > p)
    
    ## Estimate linear parameters of supply
    g <- WZPZ %*% cm
    
    ## Residuals
    xi <- delta_r - XPF %*% b
    wo <- cm - WPF %*% g
    zt <- (D - Dh)*100
    
    ## Output: parameters & primitives
    out <- list(b = b, g = g, delta = delta, cm = cm, si = si, Dh = Dh,
                xi = xi, wo = wo, zt = zt, expl = expl)
  }
  
  return(out)
}

## Moment Funcion
gmm <- function(zeta) {
  
  ## Restrictions:
  zeta <- cons(zeta)
  print(zeta)
  
  ## Outputs
  strc <- struct(zeta)
  expl <- strc$expl
  
  if(expl == 'try-error') {
    out <- 1e+10
  } else {
    
    ## Resifuals
    xi <- strc$xi
    cm <- strc$cm
    wo <- strc$wo
    wo <- wo + ((cm > p*(1-D))*(cm - p*(1-D))^2 + 100*(cm < 0)*(cm)^2) # penalizaciones
    Dh <- strc$Dh
    zt <- strc$zt
    zt <- zt + ((Dh > 1)*((Dh - 1)*100)^2 + (Dh < 0)*(Dh*100)^2) # penalizaciones
    
    ## Value of the obj. function
    om  <- c(xi, wo, zt)
    out <- t(om) %*% ZPZ2 %*% om
    out <- as.numeric(out)/1e+5
  }
  
  print(out)
  return(out)
}

## Constraints
cons <- function(zeta) {
  zeta    <- abs(zeta)
  zeta[1] <- -abs(zeta[1])
  return(zeta)
}

## Error fns: theta_1
omega1 <- function(beta) {
  alpha   <- zeta[1]
  rho     <- XBr %*% zeta[2:5]
  delta_r <- delta - rho*D - alpha*p
  xi <- delta_r - XPF %*% beta
  wo <- wo
  zt <- zt
  return(c(xi, wo, zt))
}

## Error fns: theta_2
omega2 <- function(zeta) {
  out  <- struct(zeta)
  xi   <- out$xi
  wo   <- out$wo
  zt   <- out$zt
  return(c(xi, wo, zt))
}

# ____________________________________________________________________________ ####
# END ####