###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###
### CRC: DEMAND FOR MOBILE SERVICES WITH WIN BACK STRATEGIES    ###*###*###*###*###
### DISCRETE CHOICE MODEL                                       ###*###*###*###*###
### ESTIMATE COUNTERFACTUAL EXPERIMENT 1-5 (BASE STRUCTURE)     ###*###*###*###*###
###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###


# ____________________________________________________________________________ ####
# START ####

rm(list = ls())
library(readxl)
library(plyr)
library(lubridate)

# ____________________________________________________________________________ ####
# INPUTS ####

## Paths
inpath  <- '~/Data/Processed/'
outpath <- '~/Output/'
source('~/Code/functions.R')

# ____________________________________________________________________________ ####
# DATA OBJECTS ####

## Set period to simulate
ms   <- c(7:12, 1:6)
ms[ms < 10] <- paste0('0', ms[ms < 10])
ts   <- paste(c(rep(2024, 6), rep(2025, 6)), ms, sep = '-')

## Load data
load(paste0(inpath, 'MDATA4.RData'))
DATAt <- DATA[order(DATA$t, DATA$firm, DATA$serv), ]
i     <- which(DATAt$t %in% ts)
DATA  <- DATAt[i, ]

## Sample portability and winback
load(paste0(inpath, 'WB4.RData'))
v   <- v[i, ]
pt1 <- pt1[i, ]
pt2 <- pt2[i, ]
pt3 <- pt3[i, ]
pt4 <- pt4[i, ]
wb1 <- wb1[i, ]
wb2 <- wb2[i, ]
wb3 <- wb3[i, ]
wb4 <- wb4[i, ]
wbt <- wb1 + wb2 + wb3 + wb4

## Estimates and primitives
load(paste0(outpath, 'Estimout_04.RData'))
delta <- delta[i]
cm    <- cm[i]

# ____________________________________________________________________________ ####
# SETUP DATA & PARAMETERS ####

## Price & Shares
p <- DATA$p
S <- DATA$s

## Initials
t    <- DATA$t
NS   <- ncol(v)
mkti <- match(DATA$t, unique(DATA$t))

## Parameters
deltar <- delta + zeta[11]*p

## Firm matrix
dx <- data.frame(p, XF = paste0('_', DATA$firm))
XF <- model.matrix(lm(p ~ 0 + XF, data = dx))
m  <- unique(DATA$t)
H  <- matrix(0, ncol = nrow(DATA), nrow = nrow(DATA))
for(tt in 1:length(m)) {
  x <- XF[t == m[tt], ]
  x <- x %*% t(x)
  i <- which(mkti == tt)
  H[i, i] <- x
}

# ____________________________________________________________________________ ####
# CF1:  ####

## Setup
ptc1 <- pt1*0
ptc2 <- pt2
ptc3 <- pt3
ptc4 <- pt4
wbc1 <- wb1*0
wbc2 <- wb2
wbc3 <- wb3
wbc4 <- wb4

## Compute results
cf1 <- mktsimul(p, deltar, cm, H,
                ptc1, ptc2, ptc3, ptc4, 
                wbc1, wbc2, wbc3, wbc4,
                v, zeta, a = 0.1, pup = 4)

## Save
List <- c('cf1', paste0('ptc', 1:4), paste0('wbc', 1:4))
save(list = List, file = paste0(outpath, 'CF1.RData'))

# ____________________________________________________________________________ ####
# CF2:  ####

## Setup
ptc1 <- pt1*0
ptc2 <- pt2*0
ptc3 <- pt3
ptc4 <- pt4
wbc1 <- wb1*0
wbc2 <- wb2*0
wbc3 <- wb3
wbc4 <- wb4

## Compute results
cf2 <- mktsimul(p, deltar, cm, H,
                ptc1, ptc2, ptc3, ptc4, 
                wbc1, wbc2, wbc3, wbc4,
                v, zeta, a = 0.1, pup = 4)

## Save
List <- c('cf2', paste0('ptc', 1:4), paste0('wbc', 1:4))
save(list = List, file = paste0(outpath, 'CF2.RData'))

# ____________________________________________________________________________ ####
# CF3:  ####

## Setup
ptc1 <- pt1
ptc2 <- pt2
ptc3 <- pt3
ptc4 <- pt4
wbc1 <- wb1*0
wbc2 <- wb2
wbc3 <- wb3
wbc4 <- wb4

## Compute results
cf3 <- mktsimul(p, deltar, cm, H,
                ptc1, ptc2, ptc3, ptc4, 
                wbc1, wbc2, wbc3, wbc4,
                v, zeta, a = 0.1, pup = 4)

## Save
List <- c('cf3', paste0('ptc', 1:4), paste0('wbc', 1:4))
save(list = List, file = paste0(outpath, 'CF3.RData'))

# ____________________________________________________________________________ ####
# CF4:  ####

## Setup
ptc1 <- pt1
ptc2 <- pt2
ptc3 <- pt3
ptc4 <- pt4
wbc1 <- wb1*0
wbc2 <- wb2*0
wbc3 <- wb3
wbc4 <- wb4

## Compute results
cf4 <- mktsimul(p, deltar, cm, H,
                ptc1, ptc2, ptc3, ptc4, 
                wbc1, wbc2, wbc3, wbc4,
                v, zeta, a = 0.1, pup = 4)

## Save
List <- c('cf4', paste0('ptc', 1:4), paste0('wbc', 1:4))
save(list = List, file = paste0(outpath, 'CF4.RData'))

# ____________________________________________________________________________ ####
# CF5:  ####

## Setup
ptc1 <- pt1*0
ptc2 <- pt2
ptc3 <- pt3
ptc4 <- pt4
wbc1 <- wb1*0
wbc2 <- wb2*0
wbc3 <- wb3
wbc4 <- wb4

## Compute results
cf5 <- mktsimul(p, deltar, cm, H,
                ptc1, ptc2, ptc3, ptc4, 
                wbc1, wbc2, wbc3, wbc4,
                v, zeta, a = 0.1, pup = 4)

## Save
List <- c('cf5', paste0('ptc', 1:4), paste0('wbc', 1:4))
save(list = List, file = paste0(outpath, 'CF5.RData'))

# ____________________________________________________________________________ ####
# END ####