###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###
### CRC: DEMAND FOR MOBILE SERVICES WITH WIN BACK STRATEGIES    ###*###*###*###*###
### DISCRETE CHOICE MODEL                                       ###*###*###*###*###
### ESTIMATE COUNTERFACTUAL EXPERIMENT NO. 1-5 (MERGED FIRMS)   ###*###*###*###*###
###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###


# ____________________________________________________________________________ ####
# START ####

rm(list = ls())
library(readxl)
library(plyr)
library(lubridate)

# ____________________________________________________________________________ ####
# INPUTS ####

## Paths
inpath  <- '~/Data/Processed/'
outpath <- '~/Output/'
source('~/Code/functions.R')

# ____________________________________________________________________________ ####
# DATA OBJECTS ####

## Set period to simulate
ms   <- c(7:12, 1:6)
ms[ms < 10] <- paste0('0', ms[ms < 10])
ts   <- paste(c(rep(2024, 6), rep(2025, 6)), ms, sep = '-')

## Load data
load(paste0(inpath, 'MDATA4.RData'))
DATAt <- DATA[order(DATA$t, DATA$firm, DATA$serv), ]
i     <- which(DATAt$t %in% ts)
DATA  <- DATAt[i, ]

## Sample portability and winback
load(paste0(inpath, 'WB4.RData'))
v   <- v[i, ]
pt1 <- pt1[i, ]
pt2 <- pt2[i, ]
pt3 <- pt3[i, ]
pt4 <- pt4[i, ]
wb1 <- wb1[i, ]
wb2 <- wb2[i, ]
wb3 <- wb3[i, ]
wb4 <- wb4[i, ]
wbt <- wb1 + wb2 + wb3 + wb4

## Estimates and primitives
load(paste0(outpath, 'Estimout_04.RData'))
delta <- delta[i]
cm    <- cm[i]

# ____________________________________________________________________________ ####
# SETUP DATA & PARAMETERS ####

## Price & Shares
p <- DATA$p
S <- DATA$s

## Initials
t    <- DATA$t
NS   <- ncol(v)
mkti <- match(DATA$t, unique(DATA$t))

## Parameters
deltar <- delta + zeta[11]*p

## Firm matrix
dx <- data.frame(p, XF = paste0('_', DATA$firm))
dx$XF[dx$XF %in% c('_Tigo-Une', '_Movistar')] <- '_MT'
XF <- model.matrix(lm(p ~ 0 + XF, data = dx))
m  <- unique(DATA$t)
H  <- matrix(0, ncol = nrow(DATA), nrow = nrow(DATA))
for(tt in 1:length(m)) {
  x <- XF[t == m[tt], ]
  x <- x %*% t(x)
  i <- which(mkti == tt)
  H[i, i] <- x
}

# ____________________________________________________________________________ ####
# BASELINE ####

## Setup
ptc1 <- pt1
ptc2 <- pt2
ptc3 <- pt3
ptc4 <- pt4
wbc1 <- wb1
wbc2 <- wb2
wbc3 <- wb3
wbc4 <- wb4

## Compute results
blm <- mktsimul(p, deltar, cm, H,
                ptc1, ptc2, ptc3, ptc4, 
                wbc1, wbc2, wbc3, wbc4,
                v, zeta, a = 0.5, pup = 3)
pm <- blm$pc

## Save
List <- c('blm', paste0('ptc', 1:4), paste0('wbc', 1:4))
save(list = List, file = paste0(outpath, 'BLm.RData'))

# ____________________________________________________________________________ ####
# CFm1:  ####

## Setup
ptc1 <- pt1*0
ptc2 <- pt2
ptc3 <- pt3
ptc4 <- pt4
wbc1 <- wb1*0
wbc2 <- wb2
wbc3 <- wb3
wbc4 <- wb4

## Compute results
cfm1 <- mktsimul(p = pm, deltar, cm, H,
                ptc1, ptc2, ptc3, ptc4, 
                wbc1, wbc2, wbc3, wbc4,
                v, zeta, a = 0.5, pup = 4)

## Save
List <- c('cfm1', paste0('ptc', 1:4), paste0('wbc', 1:4))
save(list = List, file = paste0(outpath, 'CFm1.RData'))

# ____________________________________________________________________________ ####
# CFm2:  ####

## Setup
ptc1 <- pt1*0
ptc2 <- pt2*0
ptc3 <- pt3
ptc4 <- pt4
wbc1 <- wb1*0
wbc2 <- wb2*0
wbc3 <- wb3
wbc4 <- wb4

## Compute results
cfm2 <- mktsimul(p = pm, deltar, cm, H,
                ptc1, ptc2, ptc3, ptc4, 
                wbc1, wbc2, wbc3, wbc4,
                v, zeta, a = 0.5, pup = 4)

## Save
List <- c('cfm2', paste0('ptc', 1:4), paste0('wbc', 1:4))
save(list = List, file = paste0(outpath, 'CFm2.RData'))

# ____________________________________________________________________________ ####
# CFm3:  ####

## Setup
ptc1 <- pt1
ptc2 <- pt2
ptc3 <- pt3
ptc4 <- pt4
wbc1 <- wb1*0
wbc2 <- wb2
wbc3 <- wb3
wbc4 <- wb4

## Compute results
cfm3 <- mktsimul(p = pm, deltar, cm, H,
                ptc1, ptc2, ptc3, ptc4, 
                wbc1, wbc2, wbc3, wbc4,
                v, zeta, a = 0.5, pup = 4)

## Save
List <- c('cfm3', paste0('ptc', 1:4), paste0('wbc', 1:4))
save(list = List, file = paste0(outpath, 'CFm3.RData'))

# ____________________________________________________________________________ ####
# CFm4:  ####

## Setup
ptc1 <- pt1
ptc2 <- pt2
ptc3 <- pt3
ptc4 <- pt4
wbc1 <- wb1*0
wbc2 <- wb2*0
wbc3 <- wb3
wbc4 <- wb4

## Compute results
cfm4 <- mktsimul(p = pm, deltar, cm, H,
                ptc1, ptc2, ptc3, ptc4, 
                wbc1, wbc2, wbc3, wbc4,
                v, zeta, a = 0.5, pup = 4)

## Save
List <- c('cfm4', paste0('ptc', 1:4), paste0('wbc', 1:4))
save(list = List, file = paste0(outpath, 'CFm4.RData'))

# ____________________________________________________________________________ ####
# CFm5:  ####

## Setup
ptc1 <- pt1*0
ptc2 <- pt2
ptc3 <- pt3
ptc4 <- pt4
wbc1 <- wb1*0
wbc2 <- wb2*0
wbc3 <- wb3
wbc4 <- wb4

## Compute results
cfm5 <- mktsimul(p = pm, deltar, cm, H,
                ptc1, ptc2, ptc3, ptc4, 
                wbc1, wbc2, wbc3, wbc4,
                v, zeta, a = 0.5, pup = 4)

## Save
List <- c('cfm5', paste0('ptc', 1:4), paste0('wbc', 1:4))
save(list = List, file = paste0(outpath, 'CFm5.RData'))

# ____________________________________________________________________________ ####
# END ####