###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###
### CRC: DEMAND FOR MOBILE SERVICES WITH WIN BACK STRATEGIES    ###*###*###*###*###
### DISCRETE CHOICE MODEL                                       ###*###*###*###*###
### COMPUTE EQ. MEASURES FOR COUNTERFACTUAL EXPERIMENTS         ###*###*###*###*###
###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###

# ____________________________________________________________________________ ####
# START ####

rm(list = ls())
library(readxl)
library(plyr)
library(lubridate)
library(ivreg)
library(xtable)
library(ggplot2)
library(reshape2)

# ____________________________________________________________________________ ####
# INPUTS ####

## Paths
inpath  <- '~/Data/'
outpath <- '~/Output/'
source('~/Code/functions.R')

# ____________________________________________________________________________ ####
# DATA OBJECTS ####

## Set period to simulate
ms   <- c(7:12, 1:6)
ms[ms < 10] <- paste0('0', ms[ms < 10])
ts   <- paste(c(rep(2024, 6), rep(2025, 6)), ms, sep = '-')

## Load data
load(paste0(inpath, 'MDATA4.RData'))
DATAt <- DATA[order(DATA$t, DATA$firm, DATA$serv), ]
i     <- which(DATAt$t %in% ts)
DATA  <- DATAt[i, ]

## Sample portability and winback
load(paste0(inpath, 'WB4.RData'))
v   <- v[i, ]
pt1 <- pt1[i, ]
pt2 <- pt2[i, ]
pt3 <- pt3[i, ]
pt4 <- pt4[i, ]
wb1 <- wb1[i, ]
wb2 <- wb2[i, ]
wb3 <- wb3[i, ]
wb4 <- wb4[i, ]
wbt <- wb1 + wb2 + wb3 + wb4

## Initials
t    <- DATA$t
NS   <- ncol(v)
mkti <- match(DATA$t, unique(DATA$t))

## Price & Shares
p <- DATA$p
S <- DATA$s
M <- DATA$M

## Estimates and primitives
load(paste0(outpath, 'Estimout_04.RData'))
delta  <- delta[i]
deltar <- delta + zeta[11]*p
cm     <- cm[i]

## Marginal utility of income
uy <- zeta[11] + zeta[10]*v
uy <- uy[1:length(ts), ]

## Baseline welfare
mui <- zeta[1]*wb1 + zeta[2]*wb2 + zeta[3]*wb3 + zeta[4]*wb4
mui <- mui + zeta[5]*pt1 + zeta[6]*pt2 + zeta[7]*pt3 + zeta[8]*pt4
mui <- mui - (zeta[9]*wbt + zeta[10]*v)*p
num <- exp(delta + mui) 
x   <- t(sapply(unique(t), function(m) colSums(num[which(t == m), ])))
W0  <- sum(rowMeans(log(x)/uy, na.rm = T))
W0

## Baseline welfare
load(paste0(outpath, 'BLm.RData'))
muim <- zeta[1]*wb1 + zeta[2]*wb2 + zeta[3]*wb3 + zeta[4]*wb4
muim <- muim + zeta[5]*pt1 + zeta[6]*pt2 + zeta[7]*pt3 + zeta[8]*pt4
muim <- muim - (zeta[9]*wbt + zeta[10]*v)*blm$pc
num  <- exp(deltar - zeta[11]*blm$pc + muim) 
x1   <- t(sapply(unique(t), function(m) colSums(num[which(t == m), ])))
W0m  <- sum(rowMeans(log(x1)/uy, na.rm = T))

# ____________________________________________________________________________ ####
# POLICY EFFECTS: BASE ####

out <- matrix(0, 5, 5)
for(k in 1:5) {
  load(paste0(outpath, 'CF', k, '.RData'))
  assign('cf', get(paste0('cf', k)))
  dq  <- sum((cf$sc - S)*M)/1e+3
  dp  <- weighted.mean(cf$pc - p, w = S*M)*1000
  dpi <- sum(((cf$pc - cm)*cf$sc - (p - cm)*S)*M)/1e+6
  ## CF welfare
  wbct <- wbc1 + wbc2 + wbc3 + wbc4
  muic <- zeta[1]*wbc1 + zeta[2]*wbc2 + zeta[3]*wbc3 + zeta[4]*wbc4
  muic <- muic + zeta[5]*ptc1 + zeta[6]*ptc2 + zeta[7]*ptc3 + zeta[8]*ptc4
  muic <- muic - (zeta[9]*wbct + zeta[10]*v)*cf$pc
  num  <- exp(deltar - zeta[11]*cf$pc + muic) 
  x    <- t(sapply(unique(t), function(m) colSums(num[which(t == m), ])))
  W1   <- sum(rowMeans(log(x)/uy, na.rm = T))
  dwf  <- (W1 - W0)*mean(M)/1e+6#*1000
  out[k, ] <- c(dq, dp, dpi, dwf, dpi + dwf)
}

x <- out
row.names(x) <- paste0('CF', 1:5)
x <- print(xtable(x))

# ____________________________________________________________________________ ####
# POLICY EFFECTS: WITH MERGER ####

out <- matrix(0, 5, 5)
for(k in 1:5) {
  load(paste0(outpath, 'CFm', k, '.RData'))
  assign('cf', get(paste0('cfm', k)))
  dq  <- sum((cf$sc - blm$sc)*M)/1e+3
  dp  <- weighted.mean(cf$pc - blm$pc, w = blm$sc*M)*1000
  dpi <- sum(((cf$pc - cm)*cf$sc - (blm$pc - cm)*blm$sc)*M)/1e+6
  ## CF welfare
  wbct <- wbc1 + wbc2 + wbc3 + wbc4
  muic <- zeta[1]*wbc1 + zeta[2]*wbc2 + zeta[3]*wbc3 + zeta[4]*wbc4
  muic <- muic + zeta[5]*ptc1 + zeta[6]*ptc2 + zeta[7]*ptc3 + zeta[8]*ptc4
  muic <- muic - (zeta[9]*wbct + zeta[10]*v)*cf$pc
  num  <- exp(deltar - zeta[11]*cf$pc + muic) 
  x    <- t(sapply(unique(t), function(m) colSums(num[which(t == m), ])))
  W1   <- sum(rowMeans(log(x)/uy, na.rm = T))
  dwf  <- (W1 - W0m)*mean(M)/1e+6#*1000
  out[k, ] <- c(dq, dp, dpi, dwf, dpi + dwf)
}

x <- out
row.names(x) <- paste0('CF', 1:5)
x <- print(xtable(x))

# ____________________________________________________________________________ ####
# MERGER EFFECTS ####

dq  <- sum((blm$sc - S)*M)/1e+3
dp  <- weighted.mean(blm$pc - p, w = S*M)*1000
dpi <- sum(((blm$pc - cm)*blm$sc - (p - cm)*S)*M)/1e+6
dwf <- (W0m - W0)*mean(M)/1e+6
xo  <- c(dq, dp, dpi, dwf, dpi + dwf)

out <- matrix(0, 5, 5)
for(k in 1:5) {
  load(paste0(outpath, 'CF', k, '.RData'))
  load(paste0(outpath, 'CFm', k, '.RData'))
  assign('cf', get(paste0('cf', k)))
  assign('cfm', get(paste0('cfm', k)))
  ## Market
  dq  <- sum((cfm$sc - cf$sc)*M)/1e+3
  dp  <- weighted.mean(cfm$pc - cf$pc, w = cf$sc*M)*1000
  dpi <- sum(((cfm$pc - cm)*cfm$sc - (cf$pc - cm)*cf$sc)*M)/1e+6
  ## CF welfare
  wbct <- wbc1 + wbc2 + wbc3 + wbc4
  muic <- zeta[1]*wbc1 + zeta[2]*wbc2 + zeta[3]*wbc3 + zeta[4]*wbc4
  muic <- muic + zeta[5]*ptc1 + zeta[6]*ptc2 + zeta[7]*ptc3 + zeta[8]*ptc4
  # No merger
  num  <- exp(deltar - zeta[11]*cf$pc + (muic - (zeta[9]*wbct + zeta[10]*v)*cf$pc)) 
  x    <- t(sapply(unique(t), function(m) colSums(num[which(t == m), ])))
  W1   <- sum(rowMeans(log(x)/abs(uy), na.rm = T))
  # Merger
  num  <- exp(deltar - zeta[11]*cfm$pc + (muic - (zeta[9]*wbct + zeta[10]*v)*cfm$pc)) 
  x1   <- t(sapply(unique(t), function(m) colSums(num[which(t == m), ])))
  W1m  <- sum(rowMeans(log(x1)/abs(uy), na.rm = T))
  # Change
  dwf      <- (W1m - W1)*mean(M)/1e+6
  out[k, ] <- c(dq, dp, dpi, dwf, dpi + dwf)
}

x <- rbind(xo, out)
row.names(x) <- c('St. Quo', paste0('CF', 1:5))
x <- print(xtable(x))

# ____________________________________________________________________________ ####
# FIN ####