###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###
### CRC: DEMAND FOR MOBILE SERVICES             ###*###*###*###*###*###*###*###*###
### DISCRETE CHOICE MODEL                       ###*###*###*###*###*###*###*###*###
### AUXILIARY FUNCTIONS                         ###*###*###*###*###*###*###*###*###
###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###*###

## Fixed point function for delta
fixedn <- function(delta, mui) {
  num   <- exp(delta + mui) ## --> (J*T)xNS
  den   <- t(sapply(unique(t), function(m) colSums(num[which(t == m), ])))[mkti, ] 
  si    <- num / (1 + den)  ## --> (J*T)xNS
  s     <- rowMeans(si)     ## --> (J*T)x1
  delta <- as.numeric(delta + log(S) - log(s)) ## --> (J*T)x1
  return(delta)
}

## Fixed point function for zeta
fixed <- function(zeta) {
  mui   <- zeta[1]*wb1 + zeta[2]*wb2 + zeta[3]*wb3 + zeta[4]*wb4
  mui   <- mui + zeta[5]*pt1 + zeta[6]*pt2 + zeta[7]*pt3 + zeta[8]*pt4
  mui   <- mui - (zeta[9]*wbt + zeta[10]*v)*p
  delta <- try(squarem(delta0, fixedn, mui = mui, control = list(tol = 1e-10)), silent = T)
  expl  <- class(delta)
  if(expl == 'try-error') {
    si <- delta <- NULL
  } else {
    delta <- delta$par
    num   <- exp(delta + mui) ## --> (J*T)xNS
    den   <- t(sapply(unique(t), function(m) colSums(num[which(t == m), ])))[mkti, ] ## --> (J*T)xNS
    si    <- num / (1 + den) ## --> (J*T)xNS
  }
  return(list(delta = delta, si = si, expl = expl))
}

## Function to recover primitives
struct <- function(zeta) {
  
  ## Fixed point for delta
  Fout  <- fixed(zeta)
  expl  <- Fout$expl
  
  if(expl == "try-error") {
    
    out <- list(expl = expl)
    
  } else {
    
    ## Delta and shares
    delta  <- Fout$delta
    si     <- Fout$si       # individual probabilities
    s      <- rowMeans(si)  # market shares
    
    ## Linear parameters of demand
    alpha  <- zeta[11]
    deltar <- delta + alpha*p
    b <- XZPZ %*% deltar
    
    ## Markups & costs:
    aim        <- -(alpha + zeta[9]*wbt + zeta[10]*v)
    dsdp       <- -(aim * si) %*% t(si) / NS            # ds_r/dp_j
    diag(dsdp) <- rowMeans(aim * si * (1 - si))         # ds_j/dp_j (r = j)
    TH         <- H * dsdp
    mkup       <- -as.numeric(solve(TH, tol = 1e-40) %*% s)
    cm         <- p - mkup # marginal costs
    
    ## Linear parameters of supply
    g <- WZPZ %*% cm
    
    ## Residuals
    xi <- deltar - XPF %*% b
    wo <- cm - WPF %*% g
    
    ## Output: parameters & primitives
    out <- list(b = b, g = g, delta = delta, cm = cm, si = si, 
                xi = xi, wo = wo, expl = expl)
  }
  
  return(out)
}

## Moment Funcion
gmm <- function(zeta) {
  
  ## Restrictions:
  zeta <- cons(zeta)
  print(zeta)
  
  ## Outputs
  strc <- struct(zeta)
  expl <- strc$expl
  
  if(expl == 'try-error') {
    out <- 1e+10
  } else {
    
    ## Resifuals
    xi <- strc$xi
    cm <- strc$cm
    wo <- strc$wo
    wo <- wo + ((cm > p)*(cm - p)^2 + (cm < 0)*(100*cm)^2) # penalizaciones
    
    ## Value of the obj. function
    om  <- c(xi, wo)
    out <- t(om) %*% ZPZ2 %*% om
    out <- as.numeric(out)/1e+5
  }
  
  print(out)
  return(out)
}

## Constraints
cons <- function(zeta) {
  zeta     <- abs(zeta)
  return(zeta)
}

## Error fns: theta_1
omega1 <- function(beta) {
  alpha   <- zeta[11]
  delta_r <- delta + alpha*p
  xi <- delta_r - XPF %*% beta
  wo <- wo
  return(c(xi, wo))
}

## Error fns: theta_2
omega2 <- function(zeta) {
  out  <- struct(zeta)
  xi   <- out$xi
  wo   <- out$wo
  return(c(xi, wo))
}

## Function to recover primitives
mktsimul <- function(p, deltar, cm, H,
                     ptc1, ptc2, ptc3, ptc4, 
                     wbc1, wbc2, wbc3, wbc4,
                     v, zeta, a = 0, pup = 10) {
  
  ## Fixed individual effects
  wbct <- wbc1 + wbc2 + wbc3 + wbc4
  mui0 <- zeta[1]*wbc1 + zeta[2]*wbc2 + zeta[3]*wbc3 + zeta[4]*wbc4
  mui0 <- mui0 + zeta[5]*ptc1 + zeta[6]*ptc2 + zeta[7]*ptc3 + zeta[8]*ptc4
  
  ## Price parameters
  alpha <- zeta[11]
  aim   <- -(alpha + zeta[9]*wbct + zeta[10]*v)
  
  # pup <- 3.5
  # a   <- 0.1
  p0  <- p
  repeat {
    ## Price effects
    mui   <- mui0 - (zeta[9]*wbct + zeta[10]*v)*p0
    delta <- deltar - alpha*p0
    
    ## Shares
    num <- exp(delta + mui)
    den <- t(sapply(unique(t), function(m) colSums(num[which(t == m), ])))[mkti, ]
    si  <- num / (1 + den) 
    s   <- rowMeans(si)
    
    ## Markups & prices:
    dsdp       <- -(aim * si) %*% t(si) / NS        
    diag(dsdp) <- rowMeans(aim * si * (1 - si))     
    TH         <- H * dsdp
    mkup       <- -as.numeric(solve(TH, tol = 1e-40) %*% s)
    pc         <- cm + mkup 
    pc[pc > pup*max(p)] <- pup*max(pc[pc < pup*max(p)])
    pc[pc < 0]          <- p0[pc < 0]
    
    ## Check convergence
    dist <- sqrt(weighted.mean((pc - p0)^2, w = s)*length(pc))
    print(dist)
    if(dist >= 1e-8) {
      p0 <- a*p0 + (1 - a)*pc
    } else {
      break
    }
  }
  
  ## Output
  out <- list(pc = pc, sc = s)
  
  return(out)
}

# ____________________________________________________________________________ ####
# END ####